/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <mach/mach_types.h>
#include "mx_version.h"

/*
 * This provides the linkage with the kernel module start/stop
 * routines.  This will not compile cleanly in the c++ environment of
 * so it is a separate file.  The Apple Project Builder IDE creates
 * this dynamically as a separte C file for Apple style drivers..
 */

extern kern_return_t _start (kmod_info_t * ki, void *data);
extern kern_return_t _stop (kmod_info_t * ki, void *data);

KMOD_EXPLICIT_DECL (com.Myricom.iokit.mx_ether, MX_SHORT_VERSION_STR, _start, _stop)
        __private_extern__ kmod_start_func_t *_realmain = 0;
        __private_extern__ kmod_stop_func_t *_antimain = 0;
